/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.jira.core.internal;

import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.CollectionsUtil;
import com.aptana.core.util.EclipseUtil;
import com.aptana.core.util.IConfigurationElementProcessor;
import com.aptana.jira.core.JiraCorePlugin;
import java.util.Set;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Plugin;

public class JiraProjectsRegistry {
    private JiraProjectInfo projectProviderInfo;
    private int highestPriority;
    private static final String ELEMENT_TYPE = "provider";
    private static final String PROJECT_PROVIDER_EXTENSION_POINT_ID = "jiraProjectProviders";
    private static final String PROJECT_CODE = "projectCode";
    private static final String PROJECT_NAME = "projectName";
    private static final String PRIORITY = "priority";
    private final int DEFAULT_PRIORITY = 60;

    private synchronized void loadProviders() {
        if (this.projectProviderInfo == null) {
            EclipseUtil.processConfigurationElements((String)"com.aptana.jira.core", (String)PROJECT_PROVIDER_EXTENSION_POINT_ID, (IConfigurationElementProcessor)new IConfigurationElementProcessor(){

                public void processElement(IConfigurationElement element) {
                    String elementName = element.getName();
                    if (JiraProjectsRegistry.ELEMENT_TYPE.equals(elementName)) {
                        try {
                            String projectName = element.getAttribute(JiraProjectsRegistry.PROJECT_NAME);
                            String projectCode = element.getAttribute(JiraProjectsRegistry.PROJECT_CODE);
                            String priorityStr = element.getAttribute(JiraProjectsRegistry.PRIORITY);
                            int priority = 60;
                            try {
                                priority = Integer.parseInt(priorityStr);
                            }
                            catch (NumberFormatException numberFormatException) {
                                // empty catch block
                            }
                            if (JiraProjectsRegistry.this.highestPriority < priority) {
                                JiraProjectsRegistry.this.highestPriority = priority;
                                JiraProjectsRegistry.this.projectProviderInfo = new JiraProjectInfo(projectName, projectCode);
                            }
                        }
                        catch (Exception e) {
                            IdeLog.logError((Plugin)JiraCorePlugin.getDefault(), (String)("Failed to load Jira project provider information from plugin: " + element.getContributor().getName()), (Throwable)e);
                        }
                    }
                }

                public Set<String> getSupportElementNames() {
                    return CollectionsUtil.newSet((Object[])new String[]{JiraProjectsRegistry.ELEMENT_TYPE});
                }
            });
        }
    }

    public JiraProjectInfo getProjectInfo() {
        this.loadProviders();
        return this.projectProviderInfo;
    }

    public static class JiraProjectInfo {
        final String projectName;
        final String projectCode;

        public JiraProjectInfo(String projectName, String projectCode) {
            this.projectName = projectName;
            this.projectCode = projectCode;
        }

        public String getProjectName() {
            return this.projectName;
        }

        public String getProjectCode() {
            return this.projectCode;
        }
    }
}

